IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Clientes_Temp_Actualizar_Cbte') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Clientes_Temp_Actualizar_Cbte 
END
GO

CREATE PROCEDURE [dbo].[CP_Clientes_Temp_Actualizar_Cbte] @LOTE VARCHAR(20) , @Id_Cliente INT
AS 
DECLARE @Mensaje			VARCHAR(100)
DECLARE @Titular			INT
DECLARE @GrupoFamiliar		INT

SET @Titular = ISNULL((SELECT Id_Cliente_Temp from clientes_temp where Id_Cliente=@Id_Cliente),0)
SET @GrupoFamiliar = ISNULL((SELECT COUNT(*) from clientes_temp where legajo=CONVERT(VARCHAR(30),@Titular)),0)

IF @Id_Cliente = 0 OR ISNULL(@LOTE,'') = ''
BEGIN
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,'No se especifico cliente o lote'			AS ErrorMessage
	RETURN 
END
BEGIN TRY
	DECLARE @trans_rec INTEGER, @trans_ND INT, @LoteND VARCHAR(20), @LoteRec VARCHAR(20), @Count SMALLINT

	
	SET @LoteND =  @LOTE
	SET @LoteRec = @LOTE

	SET @trans_ND = ISNULL((SELECT MIN(Id_trans) FROM Cbtes WHERE LOTE = @LoteND AND Id_Estado_Cbte in (1,2)),0)
	IF (@trans_ND = 0)
	BEGIN
		PRINT 'No hay trans de Factura'
	END

	SET @trans_rec = ISNULL((SELECT MAX(Id_trans) FROM Cbtes WHERE LOTE = @LoteRec AND Id_Estado_Cbte in (1,2)),0)
	IF (@trans_rec = 0)
	BEGIN
		PRINT 'No hay trans de recibo'
	END



	BEGIN TRAN

	IF (@trans_ND != 0)
	BEGIN
		UPDATE Clientes_CtaCte	SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_ND 
		UPDATE Cbtes_Items		SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_ND 
		UPDATE Cbtes			SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_ND 
	END

	IF (@trans_rec != 0)
	BEGIN
		UPDATE Clientes_CtaCte	SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_rec 
		UPDATE Cbtes_Items		SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_rec
		UPDATE Cbtes			SET Id_cliente = @Id_Cliente WHERE Id_Trans = @trans_rec
	END
	
	/*RECORRO MAS DE UNA FACTURA*/
		SET @Count = (SELECT COUNT(Lote) FROM CBTES WHERE LOTE = @LoteND AND Id_Trans <> @trans_rec) 
		IF (@Count > 1)
		BEGIN
			DECLARE @Id_Trans_Count INT

			DECLARE curCount CURSOR FOR
			SELECT Id_Trans FROM CBTES
			WHERE LOTE = @LoteND AND Id_Trans <> @trans_rec

			OPEN curCount
			FETCH NEXT FROM curCount INTO @Id_Trans_Count
			WHILE @@FETCH_STATUS = 0
			BEGIN

				UPDATE Clientes_CtaCte	SET Id_cliente = @Id_Cliente WHERE Id_Trans = @Id_Trans_Count 
				UPDATE Cbtes_Items		SET Id_cliente = @Id_Cliente WHERE Id_Trans = @Id_Trans_Count
				UPDATE Cbtes			SET Id_cliente = @Id_Cliente WHERE Id_Trans = @Id_Trans_Count
		
			FETCH NEXT FROM curCount INTO @Id_Trans_Count
			END
			CLOSE curCount
			DEALLOCATE curCount
			
		END

	/*RECORRO GRUPO FAMILIAR*/
		IF (@GrupoFamiliar>0)
		BEGIN
			DECLARE @Id_Cliente_int		INT
			DECLARE @Id_Cliente_Temp	INT
			DECLARE @Trans_Int			INT
			DECLARE @Item_Int			SMALLINT

			DECLARE curNombre CURSOR FOR
			SELECT C.Id_Trans,T.Id_Cliente, T.Id_Cliente_Temp, I.Item
			FROM Cbtes C
			LEFT JOIN Cbtes_Tipos CT ON C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
			LEFT JOIN Cbtes_Items I ON C.Id_Trans = I.Id_Trans
			LEFT JOIN Clientes_Temp T ON CONVERT(INT,I.CANTIDAD_EQUIV) = T.Id_Cliente_Temp			
			WHERE CT.Compromete_Factura = 1
			AND C.Lote = @LoteND
			AND Legajo = CONVERT(VARCHAR(30),@Titular)

			OPEN curNombre
			FETCH NEXT FROM curNombre INTO @Trans_Int, @Id_Cliente_int, @Id_Cliente_Temp, @Item_Int
			WHILE @@FETCH_STATUS = 0
			BEGIN

				UPDATE Cbtes_Items SET Id_cliente = @Id_Cliente_int WHERE Id_Trans = @Trans_Int AND CONVERT(INT,Cantidad_Equiv) = @Id_Cliente_Temp AND Item = @Item_Int
				UPDATE Cbtes_Items SET Cantidad_Equiv = 0 WHERE Id_Trans = @Trans_Int
		
			FETCH NEXT FROM curNombre INTO @Trans_Int, @Id_Cliente_int, @Id_Cliente_Temp, @Item_Int
			END
			CLOSE curNombre
			DEALLOCATE curNombre
			
		END
		
		UPDATE Cbtes_Items SET Cantidad_Equiv = 0 WHERE Id_Trans = @trans_ND 
	COMMIT
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage
END TRY  

BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   
